/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFOD;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.library.util.PlatformInfo;

class InstsOpOutputParser
extends KFODOpOutputParser {
    private List<ASMInstance> instances = new ArrayList<ASMInstance>();

    public List<ASMInstance> getInstances() {
        return this.instances;
    }

    @Override
    public void parseLine(String line) {
        String[] tokens;
        String node = "unknown";
        if (line != null && line.trim().length() > 0 && (tokens = Helper.tokenize(line)) != null && tokens.length >= 2) {
            if (!tokens[0].matches(KFOD.getSIDPattern())) {
                return;
            }
            ASMInstance instance = new ASMInstance(tokens[0], new File(tokens[1]));
            if (tokens.length == 3) {
                node = tokens[2];
            }
            if (node != null && node.indexOf("unknown") >= 0) {
                node = this.getLocalNodeName();
            }
            instance.setHostName(node);
            this.instances.add(instance);
        }
    }

    private String getLocalNodeName() {
        String node = PlatformInfo.getInstance().getFullHostName();
        int index = node.indexOf(".");
        if (index != -1) {
            node = node.substring(0, index);
        }
        return node;
    }
}

